
Imports System.Data

''' <summary>
''' Klasa Survey zapewnia dostp do informacji 
''' zawartych w ankiecie, takich jak jej pytania i tytu
''' </summary>
Public Class Survey
    Inherits SurveyBase

#Region "Zmienne prywatne"

    Private _id As Integer
    Private _name As String = String.Empty
    Private _description As String = String.Empty
    Private _iscurrentsurvey As Boolean = False

#End Region

#Region "Konstruktor(y)"

    Public Sub New()

    End Sub

#End Region

#Region "Metody publiczne"

    ''' <summary>
    ''' Pobiera z bazy danych ankiet wywoujc metod Get() klasy SurveyDB.
    ''' </summary>
    Public Shared Function [Get](ByVal id As Integer) As Survey
        Return New Survey()

    End Function

    ''' <summary>
    ''' Zapisuje ankiet w bazie danych wywoujc metod Save() klasy SurveyDB. Poniewa ta klasa
    ''' dziedziczy po SurveyBase, metod Save() mona przesoni i wykorzystane jest sowo kluczowe Me.
    ''' </summary>
    Public Overrides Function Save() As Integer
        Return SurveyDB.Save(Me)
    End Function

    ''' <summary>
    ''' Usuwa ankiet z bazy dadnych wywoujc metod Delete() klasy SurveyDB.
    ''' </summary>
    Public Shared Sub Delete(ByVal id As Integer)
        SurveyDB.Delete(id)
    End Sub

    ''' <summary>
    ''' Pobiera z bazy danych list ankiet w okrelonej kategorii.
    ''' </summary>
    ''' <returns></returns>
    Public Shared Function GetSurveyList() As DataSet
        Return SurveyDB.GetSurveyList()
    End Function

    ''' <summary>
    ''' Pobiera z bazy danych 'biec' ankiet
    ''' </summary>
    ''' <returns></returns>
    Public Shared Function GetCurrentSurvey() As DataSet
        Return SurveyDB.GetCurrentSurvey()
    End Function


    ''' <summary>
    ''' Dla danej ankiety pobiera zestaw pyta wraz z ich wielokrotnymi moliwociami wyboru. 
    ''' </summary>
    Public Shared Function GetQuestions(ByVal id As Integer) As DataSet
        Return SurveyDB.GetQuestionsForSurvey(id)
    End Function

    ''' <summary>
    ''' Pobiera lub ustawia zestaw identyfikatorw pyta w danej ankiecie. 
    ''' </summary>
    Public Shared Function GetQuestionIDs(ByVal id As Integer) As Collection
        Return SurveyDB.GetQuestionIDsForSurvey(id)
    End Function

    ''' <summary>
    ''' zapisuje zestaw odpowiedzi na pytania w danej ankiecie. 
    ''' </summary>
    Public Shared Function SaveResponses() As Boolean

        Return SurveyDB.SaveResponses()

    End Function

    ''' <summary>
    ''' zapisuje zestaw pyta dla ankiety. 
    ''' </summary>
    Public Shared Function SaveQuestion(ByVal surveyID As Integer, ByVal text As String, ByVal OptionA As String, ByVal OptionB As String, ByVal OptionC As String, ByVal OptionD As String, Optional ByVal ID As Integer = Nothing) As Boolean

        Return SurveyDB.SaveQuestion(surveyID, text, OptionA, OptionB, OptionC, OptionD, ID)

    End Function

    ''' <summary>
    ''' zapisuje ankiet jako biec 
    ''' </summary>
    Public Shared Sub SaveSurveyAsCurrent(ByVal surveyID As Integer)

        SurveyDB.SaveSurveyAsCurrent(surveyID)

    End Sub

    ''' <summary>
    ''' Usuwa z bazy danych pytanie wywoujc metod DeleteQuestion() klasy SurveyDB.
    ''' </summary>
    Public Shared Sub DeleteQuestion(ByVal id As Integer)
        SurveyDB.DeleteQuestion(id)
    End Sub

    ''' <summary>
    ''' zapisuje ankiet w bazie danych 
    ''' </summary>
    Public Shared Sub SaveSurvey(ByVal mSurvey As Survey)

        SurveyDB.Save(mSurvey)

    End Sub

    Public Shared Sub SaveSurvey(ByVal Name As String, ByVal Description As String, ByVal ID As Integer)

        Dim mSurvey As New Survey
        mSurvey.ID = ID
        mSurvey.Name = Name
        mSurvey.Description = Description
        SurveyDB.Save(mSurvey)

    End Sub


#End Region

#Region "Waciwoci publiczne"

    ''' <summary>
    ''' Pobiera lub ustawia identyfikator ankiety
    ''' </summary>
    Public Property ID() As String
        Get
            Return _id
        End Get
        Set(ByVal value As String)
            _id = value
        End Set
    End Property

    ''' <summary>
    ''' Pobiera lub ustawia nazw ankiety
    ''' </summary>
    Public Property Name() As String
        Get
            Return _name
        End Get
        Set(ByVal value As String)
            _name = value
        End Set
    End Property

    ''' <summary>
    ''' Pobiera lub ustawia opis ankiety
    ''' </summary>
    Public Property Description() As String
        Get
            Return _description
        End Get
        Set(ByVal value As String)
            _description = value
        End Set
    End Property

    ''' <summary>
    ''' Pobiera lub ustawia waciwo isCurrent ankiety. 
    ''' </summary>
    Public Property IsCurrentSurvey() As Boolean
        Get
            Return _iscurrentsurvey
        End Get
        Set(ByVal value As Boolean)
            _iscurrentsurvey = value
        End Set
    End Property




#End Region

End Class
